/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.igtooltip.blocks;

import appeng.api.client.AEStackRendering;
import appeng.api.integrations.igtooltip.TooltipBuilder;
import appeng.api.integrations.igtooltip.TooltipContext;
import appeng.api.integrations.igtooltip.providers.BodyProvider;
import appeng.api.integrations.igtooltip.providers.ServerDataProvider;
import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.core.localization.InGameTooltip;
import appeng.helpers.iface.PatternProviderLogic;
import appeng.helpers.iface.PatternProviderLogicHost;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;

public final class PatternProviderDataProvider
implements BodyProvider<PatternProviderLogicHost>,
ServerDataProvider<PatternProviderLogicHost> {
    private static final String NBT_LOCK_REASON = "craftingLockReason";
    private static final String NBT_LOCK_UNTIL_RESULT_STACK = "craftingLockUntilResultStack";

    @Override
    public void buildTooltip(PatternProviderLogicHost host, TooltipContext context, TooltipBuilder tooltip) {
        CompoundTag stack;
        String lockReason = context.serverData().m_128461_(NBT_LOCK_REASON);
        if (!lockReason.isEmpty()) {
            tooltip.addLine((Component)Component.Serializer.m_130701_((String)lockReason));
        }
        if (!(stack = context.serverData().m_128469_(NBT_LOCK_UNTIL_RESULT_STACK)).m_128456_()) {
            TextComponent stackAmount;
            Component stackName;
            GenericStack genericStack = GenericStack.readTag(stack);
            if (genericStack == null) {
                stackName = new TextComponent("ERROR");
                stackAmount = new TextComponent("ERROR");
            } else {
                stackName = AEStackRendering.getDisplayName(genericStack.what());
                stackAmount = new TextComponent(genericStack.what().formatAmount(genericStack.amount(), AmountFormat.FULL));
            }
            tooltip.addLine((Component)InGameTooltip.CraftingLockedUntilResult.text(stackName, stackAmount).m_130940_(ChatFormatting.RED));
        }
    }

    @Override
    public void provideServerData(ServerPlayer player, PatternProviderLogicHost host, CompoundTag serverData) {
        PatternProviderLogic logic = host.getLogic();
        MutableComponent reason = null;
        switch (logic.getCraftingLockedReason()) {
            case LOCK_UNTIL_PULSE: {
                reason = InGameTooltip.CraftingLockedUntilPulse.text();
                break;
            }
            case LOCK_WHILE_HIGH: {
                reason = InGameTooltip.CraftingLockedByRedstoneSignal.text();
                break;
            }
            case LOCK_WHILE_LOW: {
                reason = InGameTooltip.CraftingLockedByLackOfRedstoneSignal.text();
                break;
            }
            case LOCK_UNTIL_RESULT: {
                GenericStack stack = logic.getUnlockStack();
                if (stack != null) {
                    serverData.m_128365_(NBT_LOCK_UNTIL_RESULT_STACK, (Tag)GenericStack.writeTag(stack));
                } else {
                    CompoundTag errorDummy = new CompoundTag();
                    errorDummy.m_128359_("error", "error");
                    serverData.m_128365_(NBT_LOCK_UNTIL_RESULT_STACK, (Tag)errorDummy);
                }
                return;
            }
        }
        if (reason != null) {
            serverData.m_128359_(NBT_LOCK_REASON, Component.Serializer.m_130703_((Component)reason.m_6881_().m_130940_(ChatFormatting.RED)));
        }
    }
}

